<?php
declare(strict_types=1);

$https = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') || 
         (isset($_SERVER['SERVER_PORT']) && $_SERVER['SERVER_PORT'] == 443);

ini_set('session.use_strict_mode', '1');
ini_set('session.cookie_httponly', '1');
ini_set('session.cookie_secure', $https ? '1' : '0');

session_set_cookie_params([
  'lifetime' => 0,
  'path' => '/erp',
  'domain' => '',
  'secure' => $https,
  'httponly' => true,
  'samesite' => 'Strict',
]);

session_start();
$_SESSION = [];
if (ini_get("session.use_cookies")) {
  $params = session_get_cookie_params();
  setcookie(session_name(), '', time() - 42000,
    $params['path'], $params['domain'],
    $params['secure'], $params['httponly']
  );
}
session_destroy();

// ALSO clear SPA cookie
setcookie('erp_user', '', time() - 3600, '/erp', '', $https, false);

// Redirect to login page instead of index
header("Location: /erp/login.php");
exit;
