<?php
// One-time helper to generate password_hash() strings.
// Usage:
// 1) Open /erp/make_hash.php in browser
// 2) Type a password and click "Generate"
// 3) Copy the hash into login.php ($USERS[...] 'hash'), then delete this file.

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $p = (string)($_POST['p'] ?? '');
  if ($p === '') {
    $out = 'Please enter a password.';
  } else {
    $hash = password_hash($p, PASSWORD_DEFAULT);
    $out = $hash ?: 'Failed to hash (check PHP version)';
  }
}
?><!doctype html>
<html>
<head><meta charset="utf-8"><title>Make password hash</title></head>
<body style="font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial;padding:20px">
  <h2>Generate password_hash()</h2>
  <form method="post">
    <input type="text" name="p" style="padding:8px;width:320px" placeholder="Type a password">
    <button type="submit" style="padding:8px 12px">Generate</button>
  </form>
  <?php if (!empty($out)): ?>
    <p>Hash:</p>
    <pre style="background:#f3f4f6;padding:12px;border-radius:8px"><?=htmlspecialchars($out, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');?></pre>
    <p>Copy this string into <code>login.php</code> and clear the corresponding <code>plain</code> value.</p>
  <?php endif; ?>
</body>
</html>
